<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * 
 * Controller pentru gestionarea obiectelor din HomePage.
 * 
 */
class Admin extends MY_Controller{
    
    function __construct() 
    {
        parent::__construct();
        $this->load->library('global_library');
        $this->load->model('client_model');
        $this->load->model('user_model');
        $this->load->model('arhiva_model');
    }
    
    /**
     * 
     * Metoda pentru afisarea paginii Admin.
     * 
     */
    function index()
    {           
        $data['title']      = "Admin";

        $start              = $this->input->get('start');
        $data['start']      = (isset($start) && $start)?$start:date("Y-m")."-01";
        $stop               = $this->input->get('stop');
        $data['stop']       = (isset($stop) && $stop)?$stop:date("Y-m-d");

        $id_utilizator      = $this->login_library->getID();

        $data['id_utilizator'] = $id_utilizator;

        $this->load->view('home_page', $data);
    }

    function statusInfo()
    {
        $data_start   = $this->input->post('data_start');
        $data_stop    = $this->input->post('data_stop'); 
        
        $result = '{
        "cols": [
            {"id":"","label":"Topping","pattern":"","type":"string"},
            {"id":"","label":"Slices","pattern":"","type":"number"}
          ],';

        $result .='"rows": [';
        
        $inregistrari = $this->arhiva_model->getStatusInregistrari($data_start, $data_stop);
        if(isset($inregistrari) && $inregistrari)
        {
            $max = count($inregistrari);
            foreach($inregistrari as $k => $in)
            {
                $result .= '{"c":[{"v":"'.$in->denumire.'","f":null},{"v":'.$in->contor.',"f":null}]}';
                
                if($k<$max-1)
                    $result .=',';
            }
        }
        
        $result .= ']}';
        
        echo $result;
    }

    function stareInfo()
    {
        $data_start   = $this->input->post('data_start');
        $data_stop    = $this->input->post('data_stop'); 
        
        $result = '{
        "cols": [
            {"id":"","label":"Topping","pattern":"","type":"string"},
            {"id":"","label":"Slices","pattern":"","type":"number"}
          ],';

        $result .='"rows": [';
        
        $inregistrari = $this->arhiva_model->getStareInregistrari($data_start, $data_stop);
        if(isset($inregistrari) && $inregistrari)
        {
            $max = count($inregistrari);
            foreach($inregistrari as $k => $in)
            {
                $result .= '{"c":[{"v":"'.$in->denumire.'","f":null},{"v":'.$in->contor.',"f":null}]}';
                
                if($k<$max-1)
                    $result .=',';
            }
        }
        
        $result .= ']}';
        
        echo $result;
    }
    
    function inregInfo()
    {
        $data_start   = $this->input->post('data_start');
        $data_stop    = $this->input->post('data_stop'); 
        
        $result = '{
        "cols": [
            {"id":"","label":"Topping","pattern":"","type":"string"},
            {"id":"","label":"Inregistrari","pattern":"","type":"number"}
          ],';

        $result .='"rows": [';
        
        $inregistrari = $this->arhiva_model->getArhivaInregistrari($data_start, $data_stop);
        if(isset($inregistrari) && $inregistrari)
        {
            $max = count($inregistrari);
            foreach($inregistrari as $k => $in)
            {
                $result .= '{"c":[{"v":"'.$in->data_adaugare.'","f":null},{"v":'.$in->contor.',"f":null}]}';
                
                if($k<$max-1)
                    $result .=',';
            }
        }
        
        $result .= ']}';
        
        echo $result;
    }

    function pass($info=array())
    {
        $data['title'] = "Modifica parola";
        
        $this->load->library('login_library');
        // set title for the view
        $data['CHG_PASS_TITLE'] = "Modifica parola";//$this->lang->line('CHG_PASS_TITLE');
        $data['CHG_PASS_ACTUAL_PASS'] = "Parola actuala";//$this->lang->line('CHG_PASS_ACTUAL_PASS');
        $data['CHG_PASS_NEW_PASS'] = "Noua parola";//$this->lang->line('CHG_PASS_NEW_PASS');
        $data['CHG_PASS_CONFIRM_PASS'] = "Confirma parola";//$this->lang->line('CHG_PASS_CONFIRM_PASS');
        $data['CHG_PASS_BUTTON'] = "Schimba";//$this->lang->line('CHG_PASS_BUTTON');
        $data['ERROR_TITLE']    = "Eroare";//$this->lang->line('ERROR_TITLE');
        
        $data['id_user'] = $this->login_library->getUserId($this->login_library->getUsername());
        
        if(count($info))
            $data['info'] = $info;
        
        $this->load->view('change_pass', $data);
    }

    function change_pass()
    {
        $this->load->library('login_library');
        
        $id_user        = $this->input->post('id_user');
        $actual_pass    = $this->input->post('actual');
        $new_pass       = $this->input->post('password');
        $password_c     = $this->input->post('password_confirm');
        
        if($this->login_library->samePass($id_user, $actual_pass))
        {
            if(!$new_pass)
            {
                $this->pass(array('eroare' => 'Eroare parola lipsa.'));
                return;
            }
            if(strcmp($new_pass,$password_c))
            {
                $this->pass(array('eroare' => 'Parolele nu coincid.'));
                return;
            }
            
            $chg = $this->login_library->changePass($id_user, $new_pass);
            if($chg)
                $this->pass(array('info' => 'Parola schimbata cu success.'));
            else
                $this->pass(array('eroare' => 'Eroare parola. '));
        }
        else
            $this->pass(array('eroare' => 'Parola actuala gresita.'));
    }
   
}