<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * 
 * Controller pentru autentificarea utilizatorilor in aplicatie.
 * 
 */
class OneLogin extends CI_Controller
{
    
    function __construct() 
    {
        parent::__construct();
        $this->load->model('login_model');
        $this->session->unset_userdata('calendar');
        
        // se preia limba de afisare din sesiune
        // $language = $this->session->userdata('language');
        
        // // daca limba exista atunci incarcam cuvintele cheie pentru aceasta limba
        // if(isset($language) && $language)
        // {
        //     $this->session->set_userdata($language, $language);
        //     $this->lang->load($language, $language);
        // }
        // // altfel setam ca limba implicita limba engleza si incarcam cuvinte cheie pentru aceasta
        // else
        // {
            $this->session->set_userdata('language', 'english');
            $this->lang->load('english', 'english');
        //}
        
    }
    
    /**
     * 
     * Metoda pentru afisarea paginii de logare.
     * 
     */
    function index()
    {
        $data['LOGIN_TITLE'] = $this->lang->line('LOGIN_TITLE');
        $data['LOGIN_LOG_IN'] = $this->lang->line('LOGIN_LOG_IN');
        $data['LOGIN_USERNAME'] = $this->lang->line('LOGIN_USERNAME');
        $data['LOGIN_PASSWORD'] = $this->lang->line('LOGIN_PASSWORD');
        $data['LOGIN_REMEMBER'] = $this->lang->line('LOGIN_REMEMBER');
        $this->load->view('login_page', $data);
    }
    
    /**
     * 
     * Metoda pentru distrugerea sesiunii utilizatorului autentificat.
     * 
     */
    function logout()
    {
        // logout the user and redirect to login page
        $this->session->unset_userdata('is_logged_in');
        $this->session->unset_userdata('language');
        $this->session->unset_userdata('activ');
        $this->session->sess_destroy();
                    
        redirect('oneLogin','refresh');
    }
    
    
    /**
     * 
     * Metoda pentru autentificarea utilizatorului in aplicatie.
     * 
     */
    function login_user()
    {
        
        $data['LOGIN_TITLE']    = $this->lang->line('LOGIN_TITLE');
        $data['LOGIN_LOG_IN']   = $this->lang->line('LOGIN_LOG_IN');
        $data['LOGIN_USERNAME'] = $this->lang->line('LOGIN_USERNAME');
        $data['LOGIN_PASSWORD'] = $this->lang->line('LOGIN_PASSWORD');
        $data['LOGIN_REMEMBER'] = $this->lang->line('LOGIN_REMEMBER');
        
        // if user is already logged in then he will be redirected to home page
        $this->load->library('login_library');
        if($this->login_library->loggedIn())
            redirect('admin', 'refresh');
        
        $this->load->library('form_validation');
         
        $this->form_validation->set_rules('username', 'Nume utilizator', 'trim|required');
        $this->form_validation->set_rules('password', 'Parolă', 'trim|required');
        
           
        if($this->form_validation->run() == FALSE)
        {
            $data['error'] = $this->lang->line('ERROR_LOGIN_USER_PASS_REQUIRED');
            $this->load->view('login_page', $data);
        }
        else
        {
            if ($this->session->userdata('attempts') === FALSE)
            {
                $this->session->set_userdata('attempts', 0);
                $this->session->set_userdata('attempts_date', '');
            }
            

                if(($this->login_model->validate()) == true)
                {
                
                    $array = array(
                        'username' => $this->input->post('username'),
                        'logged_in' => true
                    );

                    $this->session->set_userdata('is_logged_in', $array);

                    $lang       =   $this->session->userdata('language');
                    $country    =   substr($lang,0,2);
                    $this->session->set_userdata('country',$country);

                    // set the 'remember_me' option
                    if ( $this->input->post( 'remember_me' ) ) // set sess_expire_on_close to 0 or FALSE when remember me is checked.
                        $this->config->set_item('sess_expire_on_close', '0'); 

                    $user_id = $this->login_library->getId();
                    $this->load->model('user_model');
                    $user = $this->user_model->getUserInfo($user_id);
                    
                    // if($user->activ==2)
                    //     redirect ("user/info");


                    redirect('admin', 'refresh');   
                }
                else
                {
                    $this->session->set_userdata('attempts',$this->session->userdata('attempts')+1);
                    $this->session->set_userdata('attempts_date',time());
                    $data['error'] = $this->lang->line('ERROR_LOGIN_USER_PASS_MISTAKE');

                    $this->load->view('login_page', $data);
                }
            
        }
        
    }
    
}
