<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * 
 * Controller pentru gestionarea arhiva
 * 
 */
class Arhiva extends MY_Controller{
    
    function __construct() 
    {
        parent::__construct();
        $this->load->model('client_model');
        $this->load->model('document_model');
        $this->load->model('arhiva_model');
        $this->load->library('login_library');
        $this->load->library('global_library');
    }

    /**
     * 
     * Metoda pentru afisarea paginii Arhiva.
     * 
     * 
     */
    function index()
    {
        $data['title'] = "Lista intrari/iesiri din arhiva";

        //jqgrid item
        $status         = 'Status';
        $doc            = 'Document';
        $client         = 'Client';
        $cod            = 'Barcode';
        $obs            = 'Observatii';
        $data_adaugare  = 'Data adaugare';
        $optiuni        = 'Optiuni';
 
        $colModel_Items = "[
                        {name:'S.denumire',index:'S.denumire',  groupOp:'and', width:'100', align:'center'},
                        {name:'I.denumire',index:'I.denumire',  groupOp:'and', width:100, align:'left'},
                        {name:'I.client',index:'I.client',  groupOp:'and', width:100, align:'center'},
                        {name:'I.',index:'I.id_document',  groupOp:'and', width:100, align:'center'},
                        {name:'I.observatii',index:'I.observatii',  groupOp:'and', width:'100', align:'center'},
                        {name:'I.data_adaugare',index:'I.data_adaugare',  groupOp:'and', width:'100', align:'center'},
                        
                        {name:'optiune',index:'optiune', width:100, editCell: false, search: false, align:'center', sortable:false,editable:false} 
                  ]";

        $colNames_Items = "['".$status."', '".$doc."', '".$client."', '".$cod."','".$obs."','".$data_adaugare."','".$optiuni."']";
        
        $data['colModel'] = $colModel_Items;
        $data['colNames'] = $colNames_Items;
        
        $this->load->view('admin/arhiva/lista_inregistrari', $data);
    }
    
    // load documente
    function loadData()
    {
            $page = isset($_POST['page'])?$_POST['page']:1; 
            $limit = isset($_POST['rows'])?$_POST['rows']:10; 
            $sidx = isset($_POST['sidx'])?$_POST['sidx']:'denumire'; 
            $sord = isset($_POST['sord'])?$_POST['sord']:'';         
            $start = $limit*$page - $limit; 
            $start = ($start<0)?0:$start; 
            $responce = (object)array();
            $where = " 1 "; 
            
            $searchField = isset($_POST['searchField']) ? $_POST['searchField'] : false;
            $searchOper = isset($_POST['searchOper']) ? $_POST['searchOper']: false;
            $searchString = isset($_POST['searchString']) ? $_POST['searchString'] : false;
            
            $ops_array = array(
                'eq'=>'=', 
                'ne'=>'<>',
                'lt'=>'<', 
                'le'=>'<=',
                'gt'=>'>', 
                'ge'=>'>=',
                'bw'=>'LIKE',
                'bn'=>'NOT LIKE',
                'in'=>'LIKE', 
                'ni'=>'NOT LIKE', 
                'ew'=>'LIKE', 
                'en'=>'NOT LIKE', 
                'in'=>'LIKE', 
                'ni'=>'NOT LIKE', 
                'ew'=>'LIKE', 
                'en'=>'NOT LIKE', 
                'cn'=>'LIKE', 
                'nc'=>'NOT LIKE' 
                );
            
            if ($_POST['_search'] == 'true') {
                
                if(isset($searchField) && $searchString)
                {
            
                foreach ($ops_array as $key=>$value){
                    if ($searchOper==$key) {
                        $ops = $value;
                    }
                }
                if($searchOper == 'eq' ) $searchString = $searchString;
                if($searchOper == 'bw' || $searchOper == 'bn') $searchString .= '%';
                if($searchOper == 'ew' || $searchOper == 'en' ) $searchString = '%'.$searchString;
                if($searchOper == 'cn' || $searchOper == 'nc' || $searchOper == 'in' || $searchOper == 'ni') $searchString = '%'.$searchString.'%';

                $where = "$searchField $ops '$searchString' ";
                }
                
                $filters = json_decode($this->input->post('filters'), true);  
                $groupOp = $filters['groupOp'];  
                if(isset($filters))
                {
                    $where = ' 1 ';
                    $ops1  = ' AND ';
                    foreach ( $filters['rules'] as $item){ 
                        $searchField = $item['field'];
                        $searchOper = $item['op'];
                        $searchString = $item['data'];
                        
                        foreach ($ops_array as $key=>$value){
                            if ($searchOper==$key) {
                                $ops1 = $value;
                            }
                        }
                        if ($searchOper == 'eq')
                            $searchString = $searchString;
                        if ($searchOper == 'bw' || $searchOper == 'bn')
                            $searchString .= '%';
                        if ($searchOper == 'ew' || $searchOper == 'en')
                            $searchString = '%' . $searchString;
                        if ($searchOper == 'cn' || $searchOper == 'nc' || $searchOper == 'in' || $searchOper == 'ni')
                            $searchString = '%' . $searchString . '%';
                        
                        $where .= $groupOp." $searchField $ops1 '$searchString' ";
                    }
                }

            }

            if(!$sidx) 
                $sidx =1;
            
            $all_results = $this->arhiva_model->getAllData();
            $count = count($all_results);  
            
            if( $count > 0 ) {
                $total_pages = ceil($count/$limit);    
            } else {
                $total_pages = 0;
            }

            if ($page > $total_pages) 
                $page=$total_pages;
            
            $base = base_url();
            
            $query = $this->arhiva_model->getAllData($start,$limit,$sidx,$sord,$where); 
            
            $responce->page = $page;
            $responce->total = $total_pages;
            $responce->records = $count;
            $i=0;
            $c=1;
            if(isset($query) && $query)
                foreach($query as $row) {
                  
                $doc            = $row->denumire;  
                $client         = ($row->client)? $row->client:"Arhiva"; 

                $href_cod       = base_url()."adm/arhiva/barcode/".$row->id_document;
                $cod            = "<a target='_blank' class='btn $row->class' href='$href_cod'><i class='fa fa-barcode'></i> ".$row->id_document."</a>";  

                $status         = "<p class='$row->class'>".$row->sts."</p>";  
                $data_adaugare  = $row->data_adaugare;
                $obs            = $row->observatii;

                $optiuni        = '';

                $responce->rows[$i]['id_client_document']=$row->id_client_document;
                $responce->rows[$i]['cell']=array($status, $doc, $client, $cod, $obs, $data_adaugare, $optiuni);
                $i++;
                $c++;
            }

        echo json_encode($responce);
    }

    function add()
    {
        $data['title'] = "Adauga document client";

        $select_client = $this->document_model->getClienti();
        $data['select_client'] = $this->global_library->createSelect($select_client, 'id_client', 'denumire', "Select Client");

        $select_docs = $this->document_model->getDocumente();
        $data['select_docs'] = $this->global_library->createSelect($select_docs, 'id_document', 'denumire', "Select Document");

        $select_status = $this->document_model->getStatus(1);
        $data['select_status'] = $this->global_library->createSelect($select_status, 'id_status', 'denumire', false);

        $select_stare = $this->document_model->getStare();
        $data['select_stare'] = $this->global_library->createSelect($select_stare, 'id_stare', 'denumire', false);
        
        $id_document      = $this->input->post('document');
        if(isset($id_document) && $id_document)
        {
            $id_utilizator  = $this->login_library->getID();
            $id_client      = $this->input->post('client');

            $infoDoc        = $this->document_model->getInfoDocument($id_document);
            $denumire       = $infoDoc->denumire;
            $descriere      = $infoDoc->descriere;

            $observatii     = $this->input->post('observatii');

            $status         = $this->input->post('status');

            $this->db->insert('client_document',array('id_client' => $id_client, 'id_document' => $id_document,'id_utilizator' => $id_utilizator, 'denumire' => $denumire, 'descriere' => $descriere, 'observatii' => $observatii, 'status' => $status, 'data_adaugare' => date('Y-m-d'), 'activ' => 1));

            $id_client_document = $this->db->insert_id();

            $this->db->where('id_document', $id_document)->update('document', array('status' => $status));

            if(isset($id_client_document) && $id_client_document)
            {
                $this->session->set_flashdata('success', 'Inregistrare cu succes!');
                redirect('adm/arhiva?success=true');
            }
            else
            {
                $this->session->set_flashdata('warning', 'Eroare la inregistrare!');
                redirect('adm/arhiva/add?success=false');
            }
        }
        
        $this->load->view('admin/arhiva/add_page', $data);
    }

    function intrare()
    {
        $data['title'] = "Intrare dosar";

        $select_client = $this->document_model->getClienti();
        $data['select_client'] = $this->global_library->createSelect($select_client, 'id_client', 'denumire', "Select Client");

        $select_docs = $this->document_model->getDocumente(2);
        $data['select_docs'] = $this->global_library->createSelect($select_docs, 'id_document', 'denumire', "Select Document");

        $select_status = $this->document_model->getStatus(1);
        $data['select_status'] = $this->global_library->createAutoSelect($select_status, 'id_status', 'denumire', 3, false);

        $select_stare = $this->document_model->getStare();
        $data['select_stare'] = $this->global_library->createSelect($select_stare, 'id_stare', 'denumire', false);
        
        $id_document      = $this->input->post('document');
        if(isset($id_document) && $id_document)
        {
            $id_utilizator  = $this->login_library->getID();
            $id_client      = $this->input->post('client');

            $infoDoc        = $this->document_model->getInfoDocument($id_document);
            $denumire       = $infoDoc->denumire;
            $descriere      = $infoDoc->descriere;

            $observatii     = $this->input->post('observatii');

            $status         = 3;//intrare in arhiva

            $this->db->insert('client_document',array('id_client' => $id_client, 'id_document' => $id_document,'id_utilizator' => $id_utilizator, 'denumire' => $denumire, 'descriere' => $descriere, 'observatii' => $observatii, 'status' => $status, 'data_adaugare' => date('Y-m-d'), 'activ' => 1));

            $id_client_document = $this->db->insert_id();

            $this->db->where('id_document', $id_document)->update('document', array('status' => $status));

            if(isset($id_client_document) && $id_client_document)
            {
                $this->session->set_flashdata('success', 'Inregistrare cu succes!');
                redirect('adm/arhiva?success=true');
            }
            else
            {
                $this->session->set_flashdata('warning', 'Eroare la inregistrare!');
                redirect('adm/arhiva/add?success=false');
            }
        }
        
        $this->load->view('admin/arhiva/intrare_page', $data);
    }

    function iesire()
    {
        $data['title'] = "Iesire dosar";

        $select_client = $this->document_model->getClienti();
        $data['select_client'] = $this->global_library->createSelect($select_client, 'id_client', 'denumire', "Select Client");

        $select_docs = $this->document_model->getDocumente(3,1);
        $data['select_docs'] = $this->global_library->createSelect($select_docs, 'id_document', 'denumire', "Select Document");

        $select_status = $this->document_model->getStatus(1);
        $data['select_status'] = $this->global_library->createAutoSelect($select_status, 'id_status', 'denumire', 2, false);

        $select_stare = $this->document_model->getStare();
        $data['select_stare'] = $this->global_library->createSelect($select_stare, 'id_stare', 'denumire', false);
        
        $id_document      = $this->input->post('document');
        if(isset($id_document) && $id_document)
        {
            $id_utilizator  = $this->login_library->getID();
            $id_client      = $this->input->post('client');

            $infoDoc        = $this->document_model->getInfoDocument($id_document);
            $denumire       = $infoDoc->denumire;
            $descriere      = $infoDoc->descriere;

            $observatii     = $this->input->post('observatii');

            $status         = 2;//iesire din arhiva

            $this->db->insert('client_document',array('id_client' => $id_client, 'id_document' => $id_document,'id_utilizator' => $id_utilizator, 'denumire' => $denumire, 'descriere' => $descriere, 'observatii' => $observatii, 'status' => $status, 'data_adaugare' => date('Y-m-d'), 'activ' => 1));

            $id_client_document = $this->db->insert_id();

            $this->db->where('id_document', $id_document)->update('document', array('status' => $status));

            if(isset($id_client_document) && $id_client_document)
            {
                $this->session->set_flashdata('success', 'Inregistrare cu succes!');
                redirect('adm/arhiva?success=true');
            }
            else
            {
                $this->session->set_flashdata('warning', 'Eroare la inregistrare!');
                redirect('adm/arhiva/add?success=false');
            }
        }
        
        $this->load->view('admin/arhiva/iesire_page', $data);
    }

    function newClient()
    {
        if (!$this->input->is_ajax_request()) {
            exit('No direct script access allowed');
        }
        $result      = array();

        $id_utilizator  = $this->login_library->getID();

        $de         = $this->input->post('de');
        $re         = $this->input->post('re');
        $em         = $this->input->post('em');

        if(isset($de) && $de)
        {
            $this->db->insert('client',array('denumire' => $de, 'id_utilizator' => $id_utilizator, 'responsabil' => $re, 'email' => $em,  'data_adaugare' => date('Y-m-d'), 'activ' => 1));

            $id_client = $this->db->insert_id();

            $select_client = $this->document_model->getClienti();
            $data['select_client'] = $this->global_library->createAutoSelect($select_client, 'id_client', 'denumire', $id_client, "Select Client");

            $result[0] = $data['select_client'];
        }

        echo json_encode($result);
    }

    function check()
    {
        if (!$this->input->is_ajax_request()) {
            exit('No direct script access allowed');
        }
        $result      = array();
        $cod         = $this->input->post('cod');

        $infoDoc     = $this->document_model->getInfoDocumentIntrare($cod);
        if(isset($infoDoc) && $infoDoc)
        {
            $result[0] = $cod;
        }
        else
        {
            $result[1] = "Document invalid!";
        }
        echo json_encode($result);
    }

    function checkArhiva()
    {
        if (!$this->input->is_ajax_request()) {
            exit('No direct script access allowed');
        }
        $result      = array();
        $cod         = $this->input->post('cod');

        $infoDocA     = $this->arhiva_model->getInfoDocumentArhiva($cod);
        if(isset($infoDocA) && $infoDocA)
        {
            $result[0] = $infoDocA->id_document;
            $result[1] = $infoDocA->id_client;

        }
        else
        {
            $result[2] = "Document invalid!";
        }
        echo json_encode($result);
    }

    function barcode($slug=NULL)
    {
        $this->load->library('document_library');

        if(isset($slug) && $slug)
        {
            $this->document_library->generareBarcode($slug);
        }
    }
  
}