<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * 
 * Controller pentru gestionarea evenimente
 * 
 */
class Utilizator extends MY_Controller{
    
    function __construct() 
    {
        parent::__construct();
        $this->load->model('user_model');
        $this->load->library('login_library');
    }
    
    /**
     * 
     * Metoda pentru afisarea paginii Eveniment
     * 
     */
    function index()
    {    
        $puncte_table = '';

        $users = $this->user_model->getUsers();

        $data['title']  = 'Utilizator';
        
        if(isset($users) && $users)
        {
            $puncte_table = 
                "<thead>
                    <tr>
                        <td><b>#</b></td>
                        <td><b>Nume</b></td>
                        <td><b>Ind</b></td>
                        <td><b>Utilizator</b></td>
                        <td><b>Tip</b></td>
                        <td><b>Grup</b></td>
                        <td><b>Email</b></td>
                        <td><b>Telefon</b></td>
                        <td><b>Cost</b></td>
                        <td><b>Status</b></td>                       
                        <td><b>Optiuni</b></td>
                    </tr>
                </thead>
                <tbody>
                ";
            $count=1;             
            foreach ($users as $sl)
            {
                $change = "<a title='Activ/Dezactiv' onclick='chg($sl->id_utilizator,$sl->activ);' class='btn btn-warning'><i class='fa fa-refresh'></i></a>";
                
                $url_e  = base_url()."adm/utilizator/edit/".$sl->id_utilizator;
                $edit   = "<a title='Modifica' href='$url_e' class='btn btn-success'><i class='fa fa-pencil-square-o'></i></a>";
                
                $url_p  = base_url()."adm/utilizator/edit_pass/".$sl->id_utilizator;
                $edit_p   = "<a title='Modifica Parola' href='$url_p' class='btn btn-primary'><i class='fa fa-key'></i></a>";

                $activ  = (isset($sl->activ) && $sl->activ>0) ? "<i class='fa fa-circle '></i>" : "<i class='fa fa-circle-o'></i>";

                $tip    = (isset($sl->drept) && $sl->drept>0) ? "<i class='fa fa-user-secret fa-2x'></i> Supervizor" : " <i class='fa fa-user'></i> Utilizator";

                $puncte_table.='<tr>';
                    $puncte_table.="<input type='hidden' class=\"sid\" value='{$sl->id_utilizator}'>";
                    $puncte_table.="<td>{$count}</td>";
                    $puncte_table.="<td>$sl->nume</td>";
                    $puncte_table.="<td>$sl->indicativ</td>";
                    $puncte_table.="<td>$sl->utilizator</td>";
                    $puncte_table.="<td>$tip</td>";
                    $puncte_table.="<td>$sl->grup</td>";
                    $puncte_table.="<td>$sl->email</td>";
                    $puncte_table.="<td>$sl->telefon</td>";
                    $puncte_table.="<td>$sl->cost lei</td>";
                    $puncte_table.="<td><a>$activ</a></td>";
                    $puncte_table.="<td>$change $edit $edit_p</td>";
                $puncte_table.='</tr>';
                
                $count++;
            }
            $puncte_table.='</tbody>';
            
            $data['serviciu_table']  = $puncte_table;
             
        }
        $this->load->view('backend/utilizator/lista_utilizatori', $data);
    }

    function profil()
    {

        $id = $this->login_library->getID();

        $data['title']  = 'Profil Utilizator';

        if(isset($id) && $id)
        {
            $infoUser = $this->user_model->getUserInfo($id);

            if(isset($infoUser) && $infoUser)
            {
                $data['info'] = $infoUser;
            }
        }

        $this->load->view('backend/utilizator/profil_utilizator',$data); 
    }
    
    function add($content = array())
    {
        if(!$this->login_library->isAdmin())
            redirect('adm/utilizator');

        $submit      = $this->input->post('email');
        if(isset($submit) && $submit)
        {
            $nume          = $this->input->post('nume');
            $indicativ     = $this->input->post('ind');
            $email         = $this->input->post('email');
            $grup          = $this->input->post('grup');
            $tip           = $this->input->post('tip');

            $telefon       = $this->input->post('telefon');
            $utilizator    = $this->input->post('utilizator');
            $parola        = $this->input->post('parola');
            $cparola       = $this->input->post('cparola');

            $cost          = $this->input->post('cost');

            $exists = $this->user_model->exists($utilizator);

            if(isset($exists) && $exists)
            {
                $data['nume']   = $nume;
                $data['email']  = $email;
                $data['error']  = "Acest utilizator='".$utilizator."' exista in baza de date.";

                $this->load->view('backend/utilizator/add_utilizator', $data);
            }
            else
            {

                if(isset($utilizator) && $utilizator && isset($email) && $email && $parola == $cparola)
                {
                    $pass = hash('sha512', $parola);

                    $this->db->insert('utilizator',array('nume'          => $nume, 
                                                         'indicativ'     => $indicativ, 
                                                         'email'         => $email,
                                                         'telefon'       => $telefon,
                                                         'utilizator'    => $utilizator, 
                                                         'cost'          => $cost,
                                                         'parola'        => $pass, 
                                                         'drept'         => $tip,
                                                         'grup'          => $grup,
                                                         'activ'         => 1, 
                                                         'data_adaugare' => date('Y-m-d')));

                    $id_utilizator = $this->db->insert_id();


                    if(isset($id_utilizator) && $id_utilizator)
                    {

                        redirect('adm/utilizator?success=true');
                    }
                    else
                    {
                        redirect('adm/utilizator/add?success=false');
                    }
                }
            }
        }
        
        $this->load->view('backend/utilizator/add_utilizator', $content);
    }
    

    function change()
    {
        if(!$this->login_library->isAdmin())
            redirect('adm/utilizator');

        if (!$this->input->is_ajax_request()) {
            exit('No direct script access allowed');
        }
       
        $id         = $this->input->post('id'); 
        $stare      = $this->input->post('stare'); 
        $opt = (isset($stare) && $stare>0)? 0 : 1;

        
        $this->db->where('id_utilizator', $id)->update('utilizator', array('activ' => $opt));
        
        echo json_encode($id);
    }

    function edit()
    {
        if(!$this->login_library->isAdmin())
            redirect('adm/utilizator');

        $id = $this->uri->segment(4);

        $data['title']  = 'Modifica Utilizator';

        if(isset($id) && $id)
        {
            $infoUser = $this->user_model->getUserInfo($id);

            if(isset($infoUser) && $infoUser)
            {
                $data['info'] = $infoUser;
            }
        }

        $id_utilizator = $this->input->post('id_utilizator');
        if(isset($id_utilizator) && $id_utilizator)
        {
            
            $nume          = $this->input->post('nume');
            $indicativ     = $this->input->post('ind');
            $email         = $this->input->post('email');
            $grup          = $this->input->post('grup');
            $tip           = $this->input->post('tip');
            $telefon       = $this->input->post('telefon');
            $cost          = $this->input->post('cost');
               
            if(isset($nume) && $nume)      
            {         

                $this->db->where('id_utilizator', $id_utilizator)->update('utilizator',array('nume'     => $nume,
                                                                                             'indicativ'=> $indicativ,  
                                                                                             'grup'     => $grup, 
                                                                                             'drept'    => $tip,  
                                                                                             'email'    => $email,
                                                                                             'cost'     => $cost,
                                                                                             'telefon'  => $telefon));

                redirect('adm/utilizator?success=true');
            }
            else
            {
                redirect('adm/utilizator/edit/'.$id_utilizator.'?success=false');
            }

        }

        $this->load->view('backend/utilizator/edit_utilizator',$data); 
    }

    function edit_pass()
    {
        if(!$this->login_library->isAdmin())
            redirect('adm/utilizator');

        $id = $this->uri->segment(4);

        $data['title']  = 'Modifica Utilizator';

        if(isset($id) && $id)
        {
            $infoUser = $this->user_model->getUserInfo($id);

            if(isset($infoUser) && $infoUser)
            {
                $data['info'] = $infoUser;
            }
        }

        $id_utilizator = $this->input->post('id_utilizator');
        if(isset($id_utilizator) && $id_utilizator)
        {
            
            $parola        = $this->input->post('parola');
            $cparola       = $this->input->post('cparola');
               
            if($parola == $cparola)      
            {         
                $pass = hash('sha512', $parola);

                $this->db->where('id_utilizator', $id_utilizator)->update('utilizator',array('parola'     => $pass));

                redirect('adm/utilizator?success=true');
            }
            else
            {
                redirect('adm/utilizator/edit_pass/'.$id_utilizator.'?success=false');
            }

        }

        $this->load->view('backend/utilizator/edit_pass',$data); 
    }

    function pass($data = array())
    {
        $id = $this->login_library->getID();

        $data['title']  = 'Modifica Parola';


        if(isset($id) && $id)
        {
            $infoUser = $this->user_model->getUserInfo($id);

            if(isset($infoUser) && $infoUser)
            {
                $data['info'] = $infoUser;
            }
        }

        $this->load->view('backend/utilizator/parola_utilizator',$data);
    }

    function change_pass()
    {
        $id_user       = $this->login_library->getID();

        $actual_pass   = $this->input->post('act_parola');
        $parola        = $this->input->post('parola');
        $cparola       = $this->input->post('cparola');

        if($this->login_library->samePass($id_user, $actual_pass))
        {
            if(!$parola)
            {
                $this->pass(array('eroare' => 'Completati parola.'));
                return;
            }
            if(strcmp($parola,$cparola))
            {
                $this->pass(array('eroare' => 'Parola si confirmarea nu se potrivesc'));
                return;
            }
            
            $chg = $this->login_library->changePass($id_user, $parola);
            if($chg)
                $this->pass(array('success' => 'Parola a fost schimbata cu success!'));
            else
                $this->pass(array('eroare' => 'Eroare! Parola nu s-a putut schimba!'));
        }
        else
        {
            $this->pass(array('eroare' => 'Parola actuala este gresita! Incercati din nou.'));
        }
        
    }
}