<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 

/**
 * 
 * Clasa pentru doc library
 * 
 */

class Document_library {

    function generareBarcode($id_inregistrare)
	{
		$ci = &get_instance();
        $ci->load->library('barcode_library');
        $ci->load->model('document_model');
		$ci->load->library('pdf');

		if(isset($id_inregistrare) && is_numeric($id_inregistrare) && $id_inregistrare)
        {
            $infoDoc = $ci->document_model->getInfoDocument($id_inregistrare);

            if(!$infoDoc)
                return false;

            require_once APPPATH.'third_party/mpdf/autoload.php'; 

            $pdf = new \Mpdf\Mpdf();

            $barcode = sprintf("%012d", $id_inregistrare);

            $filename = "doc_".date('Hisdm')."_".$id_inregistrare.".pdf";
            $img_barcode = $ci->barcode_library->generateCod($id_inregistrare);

                $html = '';
                $html   = "<html><head></head><body>";
                    $html .= "<h2>".$infoDoc->denumire."</h2>";
                    $html .= $img_barcode;
                    $html .= "<p>".$barcode."</p><br/>";
                $html .= '</body>';
                $html .= '</html>';

            //echo $html;
            $pdf->WriteHTML($html);

            $pdf->Output($filename, "I");

            $pdf = $ci->pdf->load('c', 'A4-L');
        }
	}
}