<?php

/**
 * 
 * Model pentru arhiva
 * 
 */
class Arhiva_model extends CI_Model{
    
    function __construct() 
    {
        parent::__construct();
    }

    function getAllData($start=NULL,$limit=NULL,$sidx=NULL,$sord=NULL,$where=NULL)
    {
        $ci = &get_instance();

        $q_w = ' 1 ';
        if($where != NULL)
            $q_w = $where;

        $query = 
            "
            SELECT  I.*, C.denumire as client, C.responsabil, C.email, S.denumire as sts, S.class
            FROM client_document as I
            LEFT JOIN client as C on C.id_client=I.id_client
            LEFT JOIN document as D on D.id_document=I.id_document
            LEFT JOIN status as S on S.id_status=I.status
            WHERE $q_w ";
       
        if(isset($sidx) && isset($sord))
        	$query.=" ORDER BY $sidx $sord";
         
        if(isset($limit) && $limit)
            $query.=" LIMIT  $start ,$limit";


        $q = $this->db->query($query);
        if(isset($q) && $q!=null)
            if($q->num_rows() > 0)
                return $q->result();
        
        return false;
    }

    function getAllDataScan($id_document=NULL,$start=NULL,$limit=NULL,$sidx=NULL,$sord=NULL,$where=NULL)
    {
        $ci = &get_instance();

        $q_w = '';
        if($where != NULL)
            $q_w = " AND ".$where;

        $query = 
            "
            SELECT  I.*, C.denumire as client, C.responsabil, C.email, S.denumire as sts, S.class
            FROM client_document as I
            LEFT JOIN client as C on C.id_client=I.id_client
            LEFT JOIN document as D on D.id_document=I.id_document
            LEFT JOIN status as S on S.id_status=I.status
            WHERE I.id_document= ".$ci->db->escape($id_document).$q_w;
       
        if(isset($sidx) && isset($sord))
        	$query.=" ORDER BY $sidx $sord";
         
        if(isset($limit) && $limit)
            $query.=" LIMIT  $start ,$limit";


        $q = $this->db->query($query);
        if(isset($q) && $q!=null)
            if($q->num_rows() > 0)
                return $q->result();
        
        return false;
    }

    function getStatusInregistrari($data_start, $data_stop)
    {
        //
        $ci = &get_instance();

        $id_utilizator = $ci->login_library->getId();

        $qw = 1;
        if(isset($data_start) && $data_start && isset($data_stop) && $data_stop)
            $qw = "l.data_adaugare >= '$data_start' AND l.data_adaugare <= '$data_stop'";

        $query = 
            "
            SELECT l.status, s.denumire, count(*) contor 
            FROM document l 
            LEFT JOIN status s on l.status = s.id_status 
            WHERE ".$qw."
            GROUP BY l.status";

        $q = $this->db->query($query);
        if(isset($q) && $q!=null)
            if($q->num_rows() > 0)
                return $q->result();
            
        return false;
    }

    function getStareInregistrari($data_start, $data_stop)
    {
        //
        $ci = &get_instance();

        $id_utilizator = $ci->login_library->getId();

        $qw = 1;
        if(isset($data_start) && $data_start && isset($data_stop) && $data_stop)
            $qw = "l.data_adaugare >= '$data_start' AND l.data_adaugare <= '$data_stop'";

        $query = 
            "
            SELECT l.stare, s.denumire, count(*) contor 
            FROM document l 
            LEFT JOIN stare s on l.stare = s.id_stare 
            WHERE ".$qw."
            GROUP BY l.stare";
        
        $q = $this->db->query($query);
        if(isset($q) && $q!=null)
            if($q->num_rows() > 0)
                return $q->result();
            
        return false;
    }

    function getArhivaInregistrari($data_start, $data_stop)
    {
        $ci = &get_instance();

        $id_utilizator = $ci->login_library->getId();

        $qw = 1;
        if(isset($data_start) && $data_start && isset($data_stop) && $data_stop)
            $qw = "l.data_adaugare >= '$data_start' AND l.data_adaugare <= '$data_stop'";

        $query = 
            "
            SELECT l.data_adaugare, count(*) contor 
            FROM client_document l 
            WHERE ".$qw."
            GROUP BY l.data_adaugare";


        
        $q = $this->db->query($query);
        if(isset($q) && $q!=null)
            if($q->num_rows() > 0)
                return $q->result();
            
        return false;
    }

    function getInfoDocumentArhiva($id)
    {
        $ci = &get_instance();

        $id_utilizator = $ci->login_library->getId();

        $query = 
            "
            SELECT I.*, C.denumire as client, C.responsabil, C.email, S.denumire as sts
            FROM client_document as I
            LEFT JOIN client as C on C.id_client=I.id_client
            LEFT JOIN status as S on S.id_status=I.status
            WHERE I.id_document = ".$ci->db->escape($id)." AND I.status=2";
        
        $q = $this->db->query($query);
        if(isset($q) && $q!=null)
            if($q->num_rows() > 0)
                return $q->result()[0];
            
        return false;
    }

    function getInfoClientArhiva($id)
    {
        $ci = &get_instance();

        $id_utilizator = $ci->login_library->getId();

        $query = 
            "
            SELECT I.*, C.denumire as client, C.responsabil, C.email, S.denumire as sts
            FROM client_document 
            LEFT JOIN client as C on C.id_client=I.id_client
            LEFT JOIN status as S on S.id_status=I.status
            WHERE id_client = ".$ci->db->escape($id);
        
        $q = $this->db->query($query);
        if(isset($q) && $q!=null)
            if($q->num_rows() > 0)
                return $q->result();
            
        return false;
    }

    function getInfoClientDocument($id)
    {
        $ci = &get_instance();

        $id_utilizator = $ci->login_library->getId();

        $query = 
            "
            SELECT *
            FROM client_document 
            WHERE id_client_document = ".$ci->db->escape($id);
        
        $q = $this->db->query($query);
        if(isset($q) && $q!=null)
            if($q->num_rows() > 0)
                return $q->result()[0];
            
        return false;
    }
}